﻿using Microsoft.Web.Http;
using Microsoft.Xrm.Client.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using PpmsDataService.Models;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.Http.Description;
using System.Web.OData;
using System.Web.OData.Routing;
using PpmsDataService.ModelsEnumTypes;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class ProvidersController : ODataController
    {
        public async Task<HttpResponseMessage> Get([FromODataUri] int key)
        {
            //Odata URI Parser. Not using for now but could be useful later. 
            //var serviceRootUri = new Uri(HttpContext.Current.Request.Url.AbsoluteUri);
            //var pathAndQueryUri = new Uri(HttpContext.Current.Request.Url.AbsoluteUri);
            //var model = WebApiConfig.GetEdmModel();
            //ODataUriParser parser = new ODataUriParser(model, serviceRootUri, pathAndQueryUri);
            //FilterClause filter = parser.ParseFilter();
            //SelectExpandClause expand = parser.ParseSelectAndExpand();

            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            //This Scenario matches a Provider on it's Identifier. 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                string providerIdentifier = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(providerIdentifier));
                if (ppmsProvider != null)
                {

                    var ppmsProvidersList = new List<Account> { ppmsProvider };
                    var provider =
                        await ProviderMap.MapProviders(ppmsProvidersList, queryType, context);
                    //return Ok(provider);
                    return Request.CreateResponse(provider);
                }
            }

            var message = string.Format("Provider with Identifier: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("Providers")]
        public async Task<HttpResponseMessage> Get()
        {

            var queryType = HttpContext.Current.Request.Url.Query;
            /*
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var providers = query.ApplyTo(from prov in context.AccountSet select prov);
                return Request.CreateResponse(providers);

                //var providers = await ProviderMap.MapProviders(providersList, "None", context);
                //return Request.CreateResponse(providers);
            }
    
            using (var client = new HttpClient())
            {
                client.BaseAddress = new Uri("https://dvagov-ppms-dev.crm9.dynamics.com/api/data/v8.2/");
                client.Timeout = new TimeSpan(0, 2, 0);
                var token = await PpmsContextHelper.GetToken();
                client.DefaultRequestHeaders.Authorization = new AuthenticationHeaderValue("Bearer", token);
                client.DefaultRequestHeaders.Add("OData-MaxVersion", "4.0");
                client.DefaultRequestHeaders.Add("OData-Version", "4.0");
                client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
                var result = await client.GetAsync("accounts" + queryType);
                var stringResult = await result.Content.ReadAsStringAsync();
                var providers = JsonConvert.DeserializeObject<dynamic>(stringResult);
                
                return Request.CreateResponse(stringResult);
            }
            

            //Odata URI Parser. Not using for now but could be useful later. 
            //var serviceRootUri = new Uri(HttpContext.Current.Request.Url.AbsoluteUri);
            //var pathAndQueryUri = new Uri(HttpContext.Current.Request.Url.AbsoluteUri);
            //var model = WebApiConfig.GetEdmModel();
            //ODataUriParser parser = new ODataUriParser(model, serviceRootUri, pathAndQueryUri);
            //FilterClause filter = parser.ParameterAliasNodes();
            */

            //This Scenario returns the first 10 Providers in the system. . 

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviders = context.AccountSet.Where(i => i.ppms_ProviderIdentifier != null).Take(10);
                //IQueryable<Account> ppmsProviders = (IQueryable<Account>) query.ApplyTo(from prov in context.AccountSet select prov);
                var ppmsProvidersList = ppmsProviders.ToList();
                if (ppmsProvidersList.Any())
                {
                    //Map Providers
                    var providers = await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                    return Request.CreateResponse(providers);
                }
                var message = string.Format("No Providers were found");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Provider))]
        [ODataRoute("ProviderGroupSearch")]
        public async Task<HttpResponseMessage> ProviderGroupSearch([FromODataUri] int providerType)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Define Provider type here
                /*
                int type = 0;
                switch (providerType)
                {
                    case 1:
                        //Individual
                        type = (int)Account_ppms_providertype.Individual;
                        break;
                    case 2:
                        //Group Practice / Agency
                        type = (int)Account_ppms_providertype.GroupPracticeAgency;
                        break;
                    default:
                        var noType = string.Format("A Provider Type: 1(Individual) or 2(Group Practice/Agencey) must be provided");
                        HttpError noTypeErr = new HttpError(noType);
                        return Request.CreateErrorResponse(HttpStatusCode.NotFound, noTypeErr);
                }
                */

                var ppmsProviders = from p in context.AccountSet
                                    where p.StatusCode.Value == (int)Account_StatusCode.Active
                                    where p.ppms_providertype.Value == (int)Account_ppms_providertype.GroupPracticeAgency

                                    select p;

                var ppmsProvidersList = ppmsProviders.ToList();

                if (ppmsProvidersList.Any())
                {
                    //Map Providers
                    var providers = await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                    return Request.CreateResponse(providers);
                }
                var message = string.Format("No Providers found matching given criteria");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
            //Add Optional Filters
            /*
            //If any Specialty Codes are given, check for Provider Services with match Specialty Codes
            if (specialtycode1 != null || specialtycode2 != null || specialtycode3 != null || specialtycode4 != null)
                provServices = provServices.Where(ps => ps.ppms_specialtycode.Equals(specialtycode1) || ps.ppms_specialtycode.Equals(specialtycode2) || ps.ppms_specialtycode.Equals(specialtycode3) || ps.ppms_specialtycode.Equals(specialtycode4));

            //Network Switch
            var providerNetwork = NetworkIds.GetNetwork(network);
            if (providerNetwork.Number != (int)Network.AnyNetwork)
                provServices = provServices.Where(ps => ps.ppms_network.Id == providerNetwork.Id);

            switch (gender)
            {
                case 0:
                    //Any gender
                    break;
                case 1:
                    //Male
                    provServices = provServices.Where(ps => ps.ppms_providergender.Equals(ppms_Gender.Male));
                    break;
                case 2:
                    //Female
                    provServices = provServices.Where(ps => ps.ppms_providergender.Equals(ppms_Gender.Female));
                    break;
                default:
                    break;
            }

            switch (primarycare)
            {
                case 0:
                    //No Preference
                    break;
                case 1:
                    provServices = provServices.Where(ps => ps.ppms_providerisprimarycare.Equals(true));
                    break;
                case 2:
                    provServices = provServices.Where(ps => ps.ppms_providerisprimarycare.Equals(false));
                    break;
                default:
                    break;
            }

            switch (acceptingnewpatients)
            {
                case 0:
                    //No Preference
                    break;
                case 1:
                    provServices = provServices.Where(ps => ps.ppms_provideracceptingnewpatients.Equals(true) && ps.ppms_provideracceptingva.Equals(true));
                    break;
                case 2:
                    provServices = provServices.Where(ps => ps.ppms_provideracceptingnewpatients.Equals(false) && ps.ppms_provideracceptingva.Equals(false));
                    break;
                default:
                    break;
            }

        */

        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Provider))]
        [ODataRoute("GetProviderByName")]
        public async Task<HttpResponseMessage> GetProviderByName([FromODataUri] string name)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Find Matching Provider Record
                //Treat this as multiple? 
                var ppmsProviders = context.AccountSet.Where(i => i.Name.Contains(name));
                var ppmsProvidersList = ppmsProviders.ToList();
                if (ppmsProvidersList.Any())
                {
                    //Map Providers
                    var providers = await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                    return Request.CreateResponse(providers);
                }
                var message = string.Format("No Providers found matching: " + name);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Provider))]
        [ODataRoute("GetProviderByModifiedOnDate")]
        public async Task<HttpResponseMessage> GetProviderByModifiedOnDate([FromODataUri] DateTime modifiedOnDate, [FromODataUri] int networkId)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                if (networkId != 0)
                {
                    //var network = NetworkIds.GetNetwork(networkId);

                    var providerNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.ppms_networknumber == networkId);
                    if (providerNetwork != null)
                    {
                        //Look Up Provider Va Provider Relationships first
                        var ppmsProviderServices = context.ppms_providerserviceSet.Where(i => i.ppms_network.Id == providerNetwork.Id);
                        var ppmsProviderServicesList = ppmsProviderServices.ToList();
                        if (ppmsProviderServices.Any())
                        {
                            //Max Criteria for Query Expression is 500
                            var ppmsProviderServicesListParsed = ppmsProviderServicesList.Select((x, i) => new { Index = i, Value = x }).GroupBy(x => x.Index / 500).Select(x => x.Select(v => v.Value).ToList()).ToList();
                            var ppmsProvidersList = new List<Account>();
                            foreach (var ppmsProviderServiceList in ppmsProviderServicesListParsed)
                            {
                                QueryExpression qe = new QueryExpression();
                                qe.EntityName = "account";
                                qe.ColumnSet = new ColumnSet();
                                qe.ColumnSet.AllColumns = true;
                                qe.Criteria = new FilterExpression(LogicalOperator.Or);
                                foreach (var ppmsProviderService in ppmsProviderServiceList)
                                {
                                    //Check for Provider. 
                                    if (ppmsProviderService.ppms_ProviderId == null) continue;

                                    var filter = new FilterExpression();
                                    filter.AddCondition("accountid", ConditionOperator.Equal, new object[] { ppmsProviderService.ppms_ProviderId.Id });
                                    qe.Criteria.AddFilter(filter);
                                }
                                EntityCollection ec = context.RetrieveMultiple(qe);

                                foreach (Account provider in ec.Entities)
                                {

                                    if (provider.ModifiedOn >= modifiedOnDate && provider.ModifiedOn < modifiedOnDate.AddDays(1))
                                    {
                                        ppmsProvidersList.Add(provider);
                                    }
                                }
                            }
                            if (ppmsProvidersList.Any())
                            {
                                //Map Providers
                                var providers = await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                                return Request.CreateResponse(providers);
                            }
                        }
                    }
                    var message = string.Format("No Providers found modified on this date: " + modifiedOnDate.Date);
                    HttpError err = new HttpError(message);
                    return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
                }
                //Query with no Network ID
                else
                {
                    var ppmsProviders = context.AccountSet.Where(i => i.ModifiedOn >= modifiedOnDate && i.ModifiedOn < modifiedOnDate.AddDays(1));
                    var ppmsProvidersList = ppmsProviders.ToList();
                    if (ppmsProvidersList.Any())
                    {
                        //Map Providers
                        var providers = await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                        return Request.CreateResponse(providers);
                    }
                    var message = string.Format("No Providers found modified on this date: " + modifiedOnDate.Date);
                    HttpError err = new HttpError(message);
                    return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
                }
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(ProviderNetwork))]
        [ODataRoute("GetProviderNetworks")]
        public async Task<HttpResponseMessage> GetProviderNetworks([FromODataUri] int npi)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                string providerIdentifier = npi.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(providerIdentifier));
                if (ppmsProvider != null)
                {
                    //Look Up Provider Services first
                    var ppmsProviderServices = context.ppms_providerserviceSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();

                    if (ppmsProviderServicesList.Any())
                    {
                        QueryExpression qe = new QueryExpression();
                        qe.EntityName = "ppms_vaprovidernetwork";
                        qe.ColumnSet = new ColumnSet();
                        qe.ColumnSet.AllColumns = true;
                        qe.Criteria = new FilterExpression(LogicalOperator.Or);

                        foreach (var ppmsProviderService in ppmsProviderServicesList)
                        {
                            //Check Provider Network field
                            if (ppmsProviderService.ppms_network != null)
                            {
                                var filter = new FilterExpression();
                                filter.AddCondition("ppms_vaprovidernetworkid", ConditionOperator.Equal, new object[] { ppmsProviderService.ppms_network.Id });
                                qe.Criteria.AddFilter(filter);
                            }
                        }
                        EntityCollection ec = context.RetrieveMultiple(qe);

                        var ppmsProvidersNetworksList = new List<ppms_vaprovidernetwork>();

                        foreach (ppms_vaprovidernetwork providerNetwork in ec.Entities)
                        {
                            ppmsProvidersNetworksList.Add(providerNetwork);
                        }

                        if (ppmsProvidersNetworksList.Any())
                        {
                            var providerNetworks =
                                await ProviderNetworkMap.MapProviderNetworks(ppmsProvidersNetworksList, "none", context);
                            return Request.CreateResponse(providerNetworks);
                        }
                    }
                }
                var message = string.Format("No Providers Networks found for this Provider");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Provider))]
        [ODataRoute("GetProvidersByNetwork")]
        public async Task<HttpResponseMessage> GetProvidersByNetwork([FromODataUri] int networkId)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //var network = NetworkIds.GetNetwork(networkId);
                var providerNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.ppms_networknumber == networkId);
                //Look Up Provider Va Provider Relationships first
                if (providerNetwork != null)
                {
                    var ppmsProviderServices = context.ppms_providerserviceSet.Where(i => i.ppms_network.Id == providerNetwork.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    if (ppmsProviderServicesList.Any())
                    {
                        //Max Criteria for Query Expression is 500
                        var ppmsProviderServicesListParsed = ppmsProviderServicesList.Select((x, i) => new { Index = i, Value = x }).GroupBy(x => x.Index / 500).Select(x => x.Select(v => v.Value).ToList()).ToList();
                        var ppmsProvidersList = new List<Account>();
                        foreach (var ppmsProviderServiceList in ppmsProviderServicesListParsed)
                        {
                            QueryExpression qe = new QueryExpression();
                            qe.EntityName = "account";
                            qe.ColumnSet = new ColumnSet();
                            qe.ColumnSet.AllColumns = true;
                            qe.Criteria = new FilterExpression(LogicalOperator.Or);
                            foreach (var ppmsProviderService in ppmsProviderServiceList)
                            {
                                //Check for Provider. 
                                if (ppmsProviderService.ppms_ProviderId == null) continue;

                                var filter = new FilterExpression();
                                filter.AddCondition("accountid", ConditionOperator.Equal, new object[] { ppmsProviderService.ppms_ProviderId.Id });
                                qe.Criteria.AddFilter(filter);
                            }
                            EntityCollection ec = context.RetrieveMultiple(qe);

                            foreach (Account provider in ec.Entities)
                            {
                                ppmsProvidersList.Add(provider);
                            }
                        }

                        if (ppmsProvidersList.Any())
                        {
                            //Filter list down to Distinct Providers. 
                            ppmsProvidersList.Select(x => x.Id).Distinct();
                            var providers =
                                await ProviderMap.MapProviders(ppmsProvidersList, "none", context);
                            return Request.CreateResponse(providers);
                        }
                    }
                }

                var message = string.Format("No Providers found for this network");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }


        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Provider))]
        [ODataRoute("GetProvidersByAffiliationType")]
        public async Task<HttpResponseMessage> GetProvidersByAffiliationType([FromODataUri] int affiliationTypeId)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var affiliationType = RelationshipTypeIds.GetRelationshipType(affiliationTypeId);

                //Look Up Provider Va Provider Relationships first
                var ppmsVaProviderRelationships = context.ppms_vaproviderrelationshipSet.Where(i => i.ppms_relationship.Value == affiliationType.Value);

                var ppmsVaProviderRelationshipsList = ppmsVaProviderRelationships.ToList();
                if (ppmsVaProviderRelationshipsList.Any())
                {
                    //Max Criteria for Query Expression is 500
                    var ppmsVaProviderRelationshipsListParsed = ppmsVaProviderRelationshipsList.Select((x, i) => new { Index = i, Value = x }).GroupBy(x => x.Index / 500).Select(x => x.Select(v => v.Value).ToList()).ToList();

                    var ppmsProvidersList = new List<Account>();
                    var allPpmsProviderServicesList = new List<ppms_providerservice>();
                    foreach (var vaProviderRelationshipsList in ppmsVaProviderRelationshipsListParsed)
                    {
                        foreach (var vaProviderRelationship in vaProviderRelationshipsList)
                        {
                            var ppmsProviderServices = context.ppms_providerserviceSet.Where(i => i.ppms_VAProviderRelationshipId.Id == vaProviderRelationship.Id);
                            var ppmsProviderServicesList = ppmsProviderServices.ToList();
                            allPpmsProviderServicesList.AddRange(ppmsProviderServicesList);
                        }
                    }

                    if (allPpmsProviderServicesList.Any())
                    {
                        //Max Criteria for Query Expression is 500
                        var ppmsProviderServicesListParsed = ppmsVaProviderRelationshipsList.Select((x, i) => new { Index = i, Value = x }).GroupBy(x => x.Index / 500).Select(x => x.Select(v => v.Value).ToList()).ToList();

                        foreach (var ppmsProviderServiceList in ppmsProviderServicesListParsed)
                        {
                            QueryExpression qe = new QueryExpression();
                            qe.EntityName = "account";
                            qe.ColumnSet = new ColumnSet();
                            qe.ColumnSet.AllColumns = true;
                            qe.Criteria = new FilterExpression(LogicalOperator.Or);
                            foreach (var ppmsProviderService in ppmsProviderServiceList)
                            {
                                //Check for Provider. 
                                if (ppmsProviderService.ppms_ProviderId == null) continue;

                                var filter = new FilterExpression();
                                filter.AddCondition("accountid", ConditionOperator.Equal, new object[] { ppmsProviderService.ppms_ProviderId.Id });
                                qe.Criteria.AddFilter(filter);
                            }
                            EntityCollection ec = context.RetrieveMultiple(qe);

                            foreach (Account provider in ec.Entities)
                            {
                                ppmsProvidersList.Add(provider);
                            }
                        }

                    }

                    if (ppmsProvidersList.Any())
                    {
                        //Filter list down to Distinct Providers. 
                        ppmsProvidersList.Select(x => x.Id).Distinct();
                        var providers =
                            await ProviderMap.MapProviders(ppmsProvidersList, "none", context);
                        return Request.CreateResponse(providers);
                    }
                }

                var message = string.Format("No Providers found for this Affiliation Type");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }


        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Provider))]
        [ODataRoute("GetProvidersByActiveDateRange")]
        public async Task<HttpResponseMessage> GetProvidersByActiveDateRange([FromODataUri] DateTime startDate, [FromODataUri] DateTime endDate)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Find all the History Log Records of type Provider Status - Active, and then retrieve the Providers
                var activeStatusHistoryLogs = from hl in context.ppms_historylogSet
                                              where hl.ppms_providerid != null
                                              where hl.ppms_type.Value == (int)ppms_historylog_ppms_type.ProviderStatus
                                              where hl.ppms_providerstatus.Value == (int)ppms_historylog_ppms_providerstatus.Active
                                              where hl.CreatedOn >= startDate.Date
                                              where hl.CreatedOn <= endDate.Date
                                              //where hl.ppms_statusenddate != null || hl.ppms_statusenddate !=null && hl.ppms_statusenddate.Value.Date >= endDate.Date
                                              //where hl.ppms_statusenddate.Value.Date >= endDate.Date
                                              select hl;

                var activeStatusHistoryLogsList = activeStatusHistoryLogs.ToList();
                if (activeStatusHistoryLogsList.Any())
                {
                    //Max Criteria for Query Expression is 500
                    var activeStatusHistoryLogsListParsed = activeStatusHistoryLogsList.Select((x, i) => new { Index = i, Value = x }).GroupBy(x => x.Index / 500).Select(x => x.Select(v => v.Value).ToList()).ToList();
                    var ppmsProvidersList = new List<Account>();
                    foreach (var activeHistoryLogList in activeStatusHistoryLogsListParsed)
                    {
                        QueryExpression qe = new QueryExpression();
                        qe.EntityName = "account";
                        qe.ColumnSet = new ColumnSet();
                        qe.ColumnSet.AllColumns = true;
                        qe.Criteria = new FilterExpression(LogicalOperator.Or);
                        foreach (var activeHistoryLog in activeHistoryLogList)
                        {
                            //Check the Status End Dates. 
                            if (activeHistoryLog.ppms_statusenddate != null && endDate >
                                activeHistoryLog.ppms_statusenddate.Value.ToUniversalTime().Date) continue;

                            var filter = new FilterExpression();
                            filter.AddCondition("accountid", ConditionOperator.Equal, new object[] { activeHistoryLog.ppms_providerid.Id });
                            qe.Criteria.AddFilter(filter);
                        }
                        EntityCollection ec = context.RetrieveMultiple(qe);

                        foreach (Account provider in ec.Entities)
                        {
                            ppmsProvidersList.Add(provider);
                        }
                    }
                    var providers =
                        await ProviderMap.MapProviders(ppmsProvidersList, "none", context);
                    return Request.CreateResponse(providers);

                }
                var message = string.Format("No Active Providers found on given Date Range.");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(ProviderAuthorization))]
        [ODataRoute("GetProvidersAuthorized")]
        public async Task<HttpResponseMessage> GetProvidersAuthorized([FromODataUri] int providerIdentifier, [FromODataUri] DateTime date, [FromODataUri] int network)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                string identifierMatch = providerIdentifier.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {
                    //var providerNetwork = NetworkIds.GetNetwork(network);
                    var providerNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.ppms_networknumber == network);

                    if (ppmsProvider != null && providerNetwork != null)
                    {
                        //Look up and convert Prov Identifier
                        int provId = Int32.Parse(ppmsProvider.ppms_ProviderIdentifier);

                        var providerAuthorization = new ProviderAuthorization
                        {
                            Network = providerNetwork.ppms_name,
                            ProviderIdentifier = provId,
                            OnLeie = false,
                            ActiveOnNetworkBetweenDatesGiven = false
                        };

                        var ppmsProviderServices = context.ppms_providerserviceSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id && i.ppms_network.Id == providerNetwork.Id);
                        var ppmsProviderServicesList = ppmsProviderServices.ToList();
                        var ppmsVaProviderNetworksList = new List<ppms_vaprovidernetwork>();
                        var ppmsVaProviderRelationshipsList = new List<ppms_vaproviderrelationship>();
                        if (ppmsProviderServicesList.Any())
                        {
                            QueryExpression qe = new QueryExpression();
                            qe.EntityName = "ppms_vaprovidernetwork";
                            qe.ColumnSet = new ColumnSet();
                            qe.ColumnSet.AllColumns = true;
                            qe.Criteria = new FilterExpression(LogicalOperator.Or);
                            foreach (var ppmsProviderService in ppmsProviderServicesList)
                            {
                                //Check for Relationship
                                if (ppmsProviderService.ppms_network == null) continue;

                                var filter = new FilterExpression();
                                filter.AddCondition("ppms_vaprovidernetworkid", ConditionOperator.Equal, new object[] { ppmsProviderService.ppms_network.Id });
                                qe.Criteria.AddFilter(filter);
                            }
                            EntityCollection ec = context.RetrieveMultiple(qe);

                            foreach (ppms_vaprovidernetwork vpn in ec.Entities)
                            {
                                ppmsVaProviderNetworksList.Add(vpn);
                            }

                            //Retrieve VA Provider Relationships
                            QueryExpression qe2 = new QueryExpression();
                            qe2.EntityName = "ppms_vaproviderrelationship";
                            qe2.ColumnSet = new ColumnSet();
                            qe2.ColumnSet.AllColumns = true;
                            qe2.Criteria = new FilterExpression(LogicalOperator.Or);
                            foreach (var ppmsProviderNetwork in ppmsVaProviderNetworksList)
                            {
                                //Check for Relationship
                                if (ppmsProviderNetwork.ppms_VAProviderRelationshipId == null) continue;

                                var filter = new FilterExpression();
                                filter.AddCondition("ppms_vaproviderrelationshipid", ConditionOperator.Equal, new object[] { ppmsProviderNetwork.ppms_VAProviderRelationshipId.Id });
                                qe2.Criteria.AddFilter(filter);
                            }
                            EntityCollection ec2 = context.RetrieveMultiple(qe2);

                            foreach (ppms_vaproviderrelationship vpr in ec2.Entities)
                            {
                                ppmsVaProviderRelationshipsList.Add(vpr);
                            }

                            if (ppmsVaProviderRelationshipsList.Any())
                            {
                                foreach (var relationship in ppmsVaProviderRelationshipsList)
                                {
                                    if (date < relationship.ppms_participationstartdate.Value.ToUniversalTime().Date) continue;
                                    if (relationship.ppms_participationenddate != null && date > relationship.ppms_participationenddate.Value.ToUniversalTime().Date) continue;
                                    providerAuthorization.ActiveOnNetworkBetweenDatesGiven = true;
                                }
                            }

                            //Check if there is a History Log where the Provider was in Leie Status between the dates given. 
                            var providerStatusHistoryLogs = from hl in context.ppms_historylogSet
                                                            where hl.ppms_providerid != null
                                                            where hl.ppms_providerid.Id == ppmsProvider.Id
                                                            where hl.ppms_type.Value == (int)ppms_historylog_ppms_type.ProviderStatus
                                                            where hl.ppms_providerstatus.Value == (int)ppms_historylog_ppms_providerstatus.LEIEExclusion
                                                            select hl;

                            var providerSatusHistoryLogsList = providerStatusHistoryLogs.ToList();
                            if (providerSatusHistoryLogsList.Any())
                            {
                                foreach (var providerStatusHisotryLog in providerSatusHistoryLogsList)
                                {
                                    if (date < providerStatusHisotryLog.CreatedOn.Value.ToUniversalTime().Date) continue;
                                    if (providerStatusHisotryLog.ppms_statusenddate != null && date > providerStatusHisotryLog.ppms_statusenddate.Value.ToUniversalTime().Date) continue;
                                    providerAuthorization.OnLeie = true;
                                }
                            }
                            return Request.CreateResponse(providerAuthorization);
                        }
                    }
                }
            }
            var message = string.Format("Unable able to locate Provider or Network based on Identifier & Network given.");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
        }

        //Returns only the Provider's related Specialties
        [ODataRoute("Providers({key})/ProviderSpecialties")]
        public async Task<HttpResponseMessage> GetProviderSpecialties([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {
                    var ppmsProviderSpecialties =
                        context.ppms_providertaxonomySet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);

                    var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                    //Map Provider Record. 

                    var providerSpecialties =
                        await ProviderSpecialtyMap.MapProviderSpecialties(ppmsProviderSpecialtiesList, "None", context);
                    return Request.CreateResponse(providerSpecialties);

                }
                var message = string.Format("No Provider Specialties found for provider with Identifier: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/ProviderServices")]
        public async Task<HttpResponseMessage> GetProviderServices([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {

                    //Map Provider Services
                    var ppmsProviderServices =
                        context.ppms_providerserviceSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    var providerServices =
                        await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                    return Request.CreateResponse(providerServices);

                }
                var message = string.Format("No Provider Services found for provider with Identifier" + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/ProviderContacts")]
        public async Task<HttpResponseMessage> GetProviderContacts([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {
                    //Map Provider Services
                    //Lookup and Map the Provider Contacts
                    var ppmsProviderContacts =
                        context.ContactSet.Where(i => i.ParentCustomerId.Id == ppmsProvider.Id);
                    var ppmsProviderContactsList = ppmsProviderContacts.ToList();
                    var providerContacts =
                        await ProviderContactsMap.MapProviderContacts(ppmsProviderContactsList, "None", context);
                    return Request.CreateResponse(providerContacts);

                }
                var message = string.Format("No Provider Contacts found for provider with IDentifier: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/Providers")]
        public async Task<HttpResponseMessage> GetRelatedProviders([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {
                    //Map Providers
                    var ppmsRelatedProviders =
                        context.AccountSet.Where(i => i.ParentAccountId.Id == ppmsProvider.Id);
                    var ppmsRelatedProvidersList = ppmsRelatedProviders.ToList();
                    var relatedProviders =
                        await ProviderMap.MapProviders(ppmsRelatedProvidersList, "None", context);
                    return Request.CreateResponse(relatedProviders);

                }
                var message = string.Format("No Provider Contacts found for provider with IDentifier: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/ProviderIdentifiers")]
        public async Task<HttpResponseMessage> GetProviderIdentifiers([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //int npi = key;
                string providerIdentifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(providerIdentifierMatch));
                if (ppmsProvider != null)
                {
                    //Lookup and map the Provider NPi's
                    var ppmsProviderIdentifiers =
                        context.ppms_provideridentifierSet.Where(i => i.ppms_Provider.Id == ppmsProvider.Id);
                    var ppmsProviderIdentifierList = ppmsProviderIdentifiers.ToList();
                    var providerIds =
                        await ProviderIdentifiersMap.MapProviderIdentifiers(ppmsProviderIdentifierList, "None", context);
                    return Request.CreateResponse(providerIds);

                }
                var message = string.Format("No Provider Npi's found for provider with NPI: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }


        [ODataRoute("Providers({key})/ProviderLicenses")]
        public async Task<HttpResponseMessage> GetProviderLicenses([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {

                    //Lookup and Map the Provider Licenses
                    var ppmsProviderLicenses =
                        context.ppms_providerlicensureSet.Where(i => i.ppms_ProviderIdId.Id == ppmsProvider.Id);
                    var ppmsProviderLicensesList = ppmsProviderLicenses.ToList();
                    var providerLicenses =
                        await ProviderLicensesMap.MapProviderLicenses(ppmsProviderLicensesList, "None", context);
                    return Request.CreateResponse(providerLicenses);

                }
                var message = string.Format("No Provider Licenses found for provider with Identifier: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }


        [ODataRoute("Providers({key})/ProviderCredentials")]
        public async Task<HttpResponseMessage> GetProviderCredentials([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {

                    //Lookup and Map the Provider Credentials
                    var ppmsProviderCredentials =
                        context.ppms_providercredentialSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                    var ppmsProviderCredentialsList = ppmsProviderCredentials.ToList();
                    var providerCredentials =
                        await ProviderCredentialsMap.MapProviderCredentials(ppmsProviderCredentialsList, "None", context);
                    return Request.CreateResponse(providerCredentials);

                }
                var message = string.Format("No Provider Credentials found for provider with Identifier: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/ProviderPrivileges")]
        public async Task<HttpResponseMessage> GetProviderPrivileges([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {

                    //Lookup and Map the Provider Privileges
                    var ppmsProviderPrivileges =
                        context.ppms_providerprivilegeSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                    var ppmsProviderPrivilegesList = ppmsProviderPrivileges.ToList();
                    var providerPrivileges =
                        await ProviderPrivilegesMap.MapProviderPrivileges(ppmsProviderPrivilegesList, "None", context);
                    return Request.CreateResponse(providerPrivileges);

                }
                var message = string.Format("No Provider Privileges found for provider with Identifier: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/DEAs")]
        public async Task<HttpResponseMessage> GetProviderDeas([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {

                    var ppmsDeas = context.ppms_deascheduleprivilegeSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                    var ppmsDeasList = ppmsDeas.ToList();
                    if (ppmsDeasList.Any())
                    {
                        //Map Deas
                        var deas = await DeaMap.MapDea(ppmsDeasList, "None", context);
                        return Request.CreateResponse(deas);
                    }
                }
                var message = string.Format("No Care Sites found for provider with Identifer: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/CareSites")]
        public async Task<HttpResponseMessage> GetProviderCareSites([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {

                    var ppmsCareSites = context.ppms_caresiteSet.Where(i => i.ppms_organization.Id == ppmsProvider.Id);
                    var ppmsCareSitesList = ppmsCareSites.ToList();
                    if (ppmsCareSitesList.Any())
                    {
                        //Map Care Sites
                        var careSites = await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                        return Request.CreateResponse(careSites);
                    }
                }
                var message = string.Format("No Care Sites found for provider with Identifer: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/DEAs")]
        public async Task<HttpResponseMessage> GetProviderDEAs([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {

                    var ppmsDEAs = context.ppms_deascheduleprivilegeSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                    var ppmsDEAsList = ppmsDEAs.ToList();
                    if (ppmsDEAsList.Any())
                    {
                        //Map DEAs
                        var deas = await DeaMap.MapDea(ppmsDEAsList, "None", context);
                        return Request.CreateResponse(deas);
                    }
                }
                var message = string.Format("No DEAs found for provider with Identifer: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

        [ODataRoute("Providers({key})/VaProviderRelationships")]
        public async Task<HttpResponseMessage> GetVaProviderRelationships([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {
                    var ppmsProviderServices = context.ppms_providerserviceSet.Where(i => i.ppms_ProviderId.Id == ppmsProvider.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    var ppmsVaProviderRelationshipsList = new List<ppms_vaproviderrelationship>();
                    if (ppmsProviderServicesList.Any())
                    {
                        QueryExpression qe = new QueryExpression();
                        qe.EntityName = "ppms_vaproviderrelationship";
                        qe.ColumnSet = new ColumnSet();
                        qe.ColumnSet.AllColumns = true;
                        qe.Criteria = new FilterExpression(LogicalOperator.Or);
                        foreach (var ppmsProviderService in ppmsProviderServicesList)
                        {
                            //Check for Relationship
                            if (ppmsProviderService.ppms_VAProviderRelationshipId == null) continue;

                            var filter = new FilterExpression();
                            filter.AddCondition("ppms_vaproviderrelationshipid", ConditionOperator.Equal, new object[] { ppmsProviderService.ppms_VAProviderRelationshipId.Id });
                            qe.Criteria.AddFilter(filter);
                        }
                        EntityCollection ec = context.RetrieveMultiple(qe);

                        foreach (ppms_vaproviderrelationship vpr in ec.Entities)
                        {
                            ppmsVaProviderRelationshipsList.Add(vpr);
                        }
                        //Map Va Provider Relationships
                        var vaProviderRelationships = await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipsList, "None", context);
                        return Request.CreateResponse(vaProviderRelationships);
                    }
                }
                var message = string.Format("No Va Provider Relationships found for provider with Identifer: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }



        [ODataRoute("Providers({key})/OwnedCareSite")]
        public async Task<HttpResponseMessage> GetProviderOwnedCareSite([FromODataUri] int key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {

                string identifierMatch = key.ToString();
                var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.ppms_ProviderIdentifier.Equals(identifierMatch));
                if (ppmsProvider != null)
                {

                    //Make sure we are mapping for an Organization type Provider. 
                    if (ppmsProvider?.ppms_providertype?.Value ==
                        (int)Account_ppms_providertype.GroupPracticeAgency)
                    {
                        var ppmsOwnedCareSite =
                            context.ppms_caresiteSet.FirstOrDefault(
                                i => i.Id == ppmsProvider.ppms_ownedcaresite.Id);
                        var ppmsOwnedCareSiteList = new List<ppms_caresite> { ppmsOwnedCareSite };
                        if (ppmsOwnedCareSiteList.Any())
                        {
                            //Map Care Sites
                            var ownedCareSite =
                                await CareSiteMap.MapCareSites(ppmsOwnedCareSiteList, "None", context);
                            return Request.CreateResponse(ownedCareSite);
                        }
                    }
                }
                var message = string.Format("No Owned Care Site found for provider with Identifier: " + key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }

    }
}